/*
 Usage: see printUsage()
 */

#include "RCSwitch.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream>

void printUsage()
{
	std::cout << "  Usage: sudo ./send <groupCode> <switchNumber> <command>\n";
	std::cout << "    e.g. sudo ./send 01011 3 1\n";
	std::cout << "         sudo ./send <groupNumber> <switchNumber> <command>\n";
	std::cout << "    e.g. sudo ./send 4 3 0\n";
	std::cout << "         sudo ./send <familyCharacter> <groupNumber> <switchNumber> <command>\n";
	std::cout << "    e.g. sudo ./send c 2 3 1\n";
	std::cout << "         sudo ./send <dipSwitchGroup> <dipSwitchUnit> <command>\n";
	std::cout << "    e.g. sudo ./send 11100 00001 1\n";
	std::cout << "         sudo ./send <bin> <bin> <bin> <bin>\n";
	std::cout << "    e.g. sudo ./send 111111111111111111111111 111111111111111111111111 111111111111111111111111 111111111111111111111111\n";
	std::cout << "         sudo ./send <bin> <bin> <bin> <bin> <pulseLength>\n";
	std::cout << "    e.g. sudo ./send 111111111111111111111111 111111111111111111111111 111111111111111111111111 111111111111111111111111 220\n";	
	std::cout << "         sudo ./send <bin>\n";
	std::cout << "    e.g. sudo ./send 111111111111111111111111\n";
	std::cout << "\n";
	std::cout << "  Command is 0 for OFF and 1 for ON\n";
	std::cout << "\n";
	std::cout << "  See http://code.google.com/p/rc-switch/wiki/HowTo_OperateLowCostOutlets for more information about supported switches\n";
}

int main(int argc, char *argv[]) {
    
    /*
     output PIN is hardcoded for testing purposes
     see https://projects.drogon.net/raspberry-pi/wiringpi/pins/
     for pin mapping of the raspberry pi GPIO connector
     */
    int PIN = 0;
	if (wiringPiSetup () == -1) return 1;
	piHiPri(99);
	RCSwitch mySwitch = RCSwitch();
	mySwitch.enableTransmit(PIN);
	
	if(argc == 4)
	{
		char* sGroup = argv[1];
		char* sSwitch = argv[2];
		int nSwitchNumber = atoi(argv[2]);

		int command  = atoi(argv[3]);
		
		if(strlen(sGroup) > 2)
		{
			//Type A: 10 pole DIP switches
			printf("sending [Type A] groupCode[%s] switchNumber[%s] command[%i]\n", sGroup, sSwitch, command);

			switch(command) {
				case 1:
					if (strlen(sSwitch) > 2) {
						mySwitch.switchOn(sGroup, sSwitch);
					} else {
						mySwitch.switchOn(sGroup, nSwitchNumber);
					}
					break;
				case 0:
					if (strlen(sSwitch) > 2) {
						mySwitch.switchOff(sGroup, sSwitch);
					} else {
						mySwitch.switchOff(sGroup, nSwitchNumber);
					}
					break;
				default:
					printf("command[%i] is unsupported\n", command);
					printUsage();
					return -1;
			}
			return 0;
		} else {
			//Type B: Two rotary/sliding switches
			int nGroupNumber = atoi(sGroup);
			printf("sending [Type B] groupNumber[%i] switchNumber[%i] command[%i]\n", nGroupNumber, nSwitchNumber, command);
			switch(command) {
				case 1:
					mySwitch.switchOn(nGroupNumber, nSwitchNumber);
					break;
				case 0:
					mySwitch.switchOff(nGroupNumber, nSwitchNumber);
					break;
				default:
					printf("command[%i] is unsupported\n", command);
					printUsage();
					return -1;
			}
			return 0;
		}
	}
	else if(argc == 6)
	{
		char* bin1 = argv[1];
		if (strlen(bin1) > 20)
		{
			//Type C: Intertechno
			char* binary1 = argv[1];
			char* binary2 = argv[2];
			char* binary3 = argv[3];
			char* binary4 = argv[4];

			int pulseLength = atoi(argv[5]);
			mySwitch.setProtocol(4);
	        mySwitch.setRepeatTransmit(2);
	        mySwitch.setPulseLength(pulseLength);

			//printf("sending [4 Commands] command[%s] command[%s] command[%s] command[%s]\n", binary1, binary2, binary3, binary4);

			mySwitch.send(binary1);
			mySwitch.send(binary2);
			mySwitch.send(binary3);
			mySwitch.send(binary4);
			/*delay(pulseLength);
			mySwitch.send(binary2);
			delay(pulseLength);
			mySwitch.send(binary3);
			delay(pulseLength);
			mySwitch.send(binary4);*/
			return 0;
		}
	}
	else if(argc == 5)
	{
		char* bin1 = argv[1];
		if (strlen(bin1) > 20)
		{
			//Type C: Intertechno
			char* binary1 = argv[1];
			char* binary2 = argv[2];
			char* binary3 = argv[3];
			char* binary4 = argv[4];
			
			mySwitch.setProtocol(4);
	        mySwitch.setRepeatTransmit(2);
	        mySwitch.setPulseLength(220);

			printf("sending [4 Commands] command[%s] command[%s] command[%s] command[%s]\n", binary1, binary2, binary3, binary4);

			mySwitch.send(binary1);
			delay(100);
			mySwitch.send(binary2);
			delay(100);
			mySwitch.send(binary3);
			delay(100);
			mySwitch.send(binary4);
			delay(100);
			return 0;
		}
		else
		{
			//Type C: Intertechno
			char* sFamily = argv[1];
			int nGroup = atoi(argv[2]);
			int nDevice = atoi(argv[3]);
			
			int command = atoi(argv[4]);
	    
			printf("sending [Type C] family[%s] groupNumber[%i] switchNumber[%i] command[%i]\n", sFamily, nGroup, nDevice, command);

			switch(command) {
				case 1:
					mySwitch.switchOn(sFamily[0], nGroup, nDevice);
					break;
				case 0:
					mySwitch.switchOff(sFamily[0], nGroup, nDevice);
					break;
				default:
					printf("command[%i] is unsupported\n", command);
					printUsage();
					return -1;
			}
			return 0;
		}


	    
	}
	else if(argc == 3)
	{
		char* bin1 = argv[1];
		if (strlen(bin1) > 20)
		{
			//Type C: Intertechno
			char* binary1 = argv[1];
			
			int pulseLength = atoi(argv[2]);
	        
	        mySwitch.setProtocol(1);
			mySwitch.setPulseLength(pulseLength);
			mySwitch.setRepeatTransmit(10);
			printf("sending [1 Command] command[%s]\n", binary1);

			mySwitch.send(binary1);
			//mySwitch.send(5393, 24);
			return 0;
		}
	}
	else if(argc == 2)
	{
		char* bin1 = argv[1];
		if (strlen(bin1) > 20)
		{
			//Type C: Intertechno
			char* binary1 = argv[1];
			
			
	        
	        mySwitch.setProtocol(1);
			mySwitch.setPulseLength(350);
			mySwitch.setRepeatTransmit(10);
			printf("sending [1 Command] command[%s]\n", binary1);

			mySwitch.send(binary1);
			//mySwitch.send(5393, 24);
			return 0;
		}
	}
	else
	{
		printUsage();
	}
	return 1;
}
